/*==============================================================================
 MASTER DATA PREPARATION
==============================================================================
Purpose:
Executes all data preparation steps sequentially to transform raw Call Report
data into a dataset ready for estimation. This master file coordinates the execution
of individual data preparation modules.

Structure:
- Initial Data Loading (embedded in this master file)
- Part 1A: Deposit volume & interest variable construction
- Part 1B: Final panel data cleaning
- Part 1C: Sample restrictions

Input:  Call Report data (data/raw/$raw_data_DSSW.dta) (see MASTER.do for definition of the global)
        Bloomberg Index data (data/raw/indices_price_oad.dta)
Output: Prepared panel dataset (data/temp/call_reports_prepared.dta)

Last updated: Aug 9, 2025
==============================================================================*/

clear all // Clear memory of any previous dataset
display "==================================================================="
display "               MASTER DATA PREPARATION"
display "==================================================================="

//==============================================================================
// Initial Data Loading and Setup
//==============================================================================
display "--- Starting Initial Data Loading and Setup ---"


// Load raw Call Reports data
use "$raw_data_DSSW", clear

// Identify the start and end years for the dataset
//gen year = year(dofq(yq))
local start_year = year[1]
local end_year = year[_N]

display "--- Initial Data Loading completed ---"

//==============================================================================
// Part 1A: Deposit Volume & Interest Variable Construction
//==============================================================================
display "Executing Part 1A: Deposit Volume & Interest Variable Construction"
do "$path_code/01_data_preparation/1a_deposit_construction.do" // Construct deposit and interest rates related variables

//==============================================================================
// Part 1B: Final Panel Data Cleaning
//==============================================================================
display "Executing Part 1B: Final Panel Data Cleaning"
do "$path_code/01_data_preparation/1b_final_cleaning.do" // Perform final cleaning and consistency checks

//==============================================================================
// Part 1C: Sample Restrictions
//==============================================================================
display "Executing Part 1C: Sample Restrictions"
do "$path_code/01_data_preparation/1c_sample_restrictions.do" // Apply sample inclusion/exclusion criteria

// COMPLETION: save data set.
save "$path_clean/call_reports_prepared.dta", replace

display "==================================================================="
display "           DATA PREPARATION COMPLETED SUCCESSFULLY"
display "==================================================================="
display "Final dataset saved as: call_reports_prepared.dta"